//16th fixed Melodyloop[c].SEQr, =========================================================
//connect to a Triggermatrix with melody retrigger - to get melody-beatstructure=======
//============2017 by Michael Sigl aka "Phatline,GreatFullTekk,GuteSigl,Technomiliz..."
//non-commercial use only. All other rights reserved. Mioint Based > www.ucapps.de=====
//thx @ TK 4 MIOS==============//
//=====================================================================================
#include <mios32.h>
#include "app.h"
#include <FreeRTOS.h>
#include <portmacro.h>
#include <task.h>
#include <queue.h>
#include <semphr.h>
#include "tasks.h"
#include "file.h"
#include <string.h>
#include <stdio.h>
#include <math.h>
#include <seq_bpm.h>
#include <seq_midi_out.h>
#include "seq.h"
#include <app_lcd.h>

// MUTEX
xSemaphoreHandle xSDCardSemaphore; 	// take and give access to SD-Card
xSemaphoreHandle xLCDSemaphore;		// take and give access to LCD
#define MUTEX_LCD_TAKE { while( xSemaphoreTakeRecursive(xLCDSemaphore, (portTickType)0) != pdTRUE ); }  //a Mutex reserve a Resoure (LCD or SD-Card) for a task, until it is given away...
#define MUTEX_LCD_GIVE { xSemaphoreGiveRecursive(xLCDSemaphore); }

// Task Prioritys	
#define PRIORITY_MENUE	        ( tskIDLE_PRIORITY + 3 ) //2: slow
#define PRIORITY_TASK_SEQ	    ( tskIDLE_PRIORITY + 4 ) //4: higher priority than MIDI receive task!
#define PRIORITY_SD             ( tskIDLE_PRIORITY + 3 ) //3: Mios standart
#define PRIORITY_Edit_Clip  	( tskIDLE_PRIORITY + 3)  //3: Mios standart
#define PRIORITY_Note_Buffer   	( tskIDLE_PRIORITY + 2 ) //3: Mios standart
#define PRIORITY_REC_PLAY	    ( tskIDLE_PRIORITY + 3 ) //4: high
#define PRIORITY_Counter	    ( tskIDLE_PRIORITY + 3 ) //3: Mios standart
#define PRIORITY_Decay	        ( tskIDLE_PRIORITY + 3 ) //3: Mios standart ---- 5highest, 1lowest Priority
#define APP_EDIT_TEST 1

// local prototype of the task function
static  s32 APP_MIDI_TimeOut(mios32_midi_port_t port);
static  s32 NOTIFY_MIDI_Rx  (mios32_midi_port_t port, u8 byte);
static void TASK_SEQ       (void *pvParameters);
static void SD(u8 track, u16 clip, u16 job);
static void Edit_Clip(u8 track, u16 clip, u16 job); 
static void Note_Buffer(u8 velocity,  u8 note);
static void Counter(void *pvParameters);
static void Decay(void *pvParameters);



//Card-Clip-Container
 store_t loop[8];
 store_t loop_copy;
    //initalize 1 Clip in order to have a beatstructure


 
 static file_t midifile_fi; //used to read files from SD-Card

 
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// System Variables >>> 
////////////////////////////////////////////////
    u8 ClockPortIN = 32;    //Midiclock Input Port (Midiclock Slave)
    u8 MelPortOut  = 33;     //MeloTrigger Midi-Port, [32=UART0=Midi-A, 33=UART1=Midi-B]...
    u8 MeloOutCh[16] ={0,0,1,1,2,2, 3,3,4,4,5,5, 6,6,7,7};  //Midi-Output-Channel Set...0-5 Poly-Melody && 6-15 is not used.
    
// ProgramChange //Send Receive  		
    u8 PCPortIN = 32; //Receives ProgramChange Messages on Port?
    u8 PCReceive = 1; //Activate Programchange Receive
    u8 PCChIN = 15;   //ProgramChange Input Channel

// Melody - Keyboard input
    u8 MelPortIn = 33;	//MidiPort - Melody-Line-Input
    u8 melo_input_ch[2] = {0,1}; //Midi-Input-Channels, you can connect 2 devices 0=Midichannel 1, 1=Midichannel 2,... 15=Midichannel 16
    u8 MelIroute[2] = {1,1}; //Melody Input Channel select (for example in use of 2 keyboards

// Syncronize Setting  -  Timing
    s16 RecOffset = 1;
    s16 RecOffsetCalc = 1;

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////   

// Some Copy Paste Arrays
  u16 StepFocus[8] = {0,0,0,0,0,0,0,0}; //Currently edited Step of Track
//  u16 SEQ_copy[512][8]  = {{}}; //Copy actual Track into ClipboardBuffer
//  u16 MSQ_copy[512]     = {}; //Copy actual Track into ClipboardBuffer
//  u16 PB_copy [512]     = {}; //Copy actual Track into ClipboardBuffer  
//  u16 tact_info_copy[32] = {}; //Copy bpm, loop length, tact and so on 

  u8  StepClipBoard[8] = {};   //Just a memory container to copy paste SEQ Steps
  
//  char edit[4] = {1,1,1,1}; //PB, SEQ, MSQ, Beatstructure,    Edit Flags for copy paste clear
  u8 edit = 0xff; //PB, SEQ, MSQ, Beatstructure,    Edit Flags for copy paste clear

  char mute[8]  =       { 1,1,1,1,1,1,1,1 }; //ACTIVATE Button
  char REC_PB_with_Notes[8]={ 1,1,1,1,1,1,1,1 }; //Record Pitchbend with Notes
  char REC_PB[8]    =       {}; //Record Pitchbend without changing notes
  char REC[8]       = {};

//Loop Stuff
  char NeedSync = 0;    //to indicate that PageFirst/Last has changed, or the DIRECTION, or Loop LengthBtn....
   u16 MainLoop = 16;
   u16 Loop[8] = {0,0,0,0,0,0,0,0};
   s16 MainDelay = 0; //the main TIC-Delay
   u16 loop_step_pos[8] = {1,1,1,1, 1,1,1,1}; // straight step position
   u16 main_step_pos = 1;  // the Main - Song position (you dont hear that, that is only for SYNC.

//Tact-Related SEQ Stuff @ 384 PPQN
  s16 Tic = 384;  //32x12=384 tics between 2 Notes -- not to be saved ... just to calculate
  s8  PpqnDivider  = 8; //4=16th speed, 2:8th speed
  u8  TrackFocus   = 0;               //Currently edited Track

  u8  RecMode = 0; //0:Realtime, 1:StepEnter


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Coding only Variables >>>No Settings here<<<
////should not be saved in Patchfile on SD
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//Retrigger
   u8  MeloDecayTIMER[8][128] = {{}}; //MidiDecayCounter-- Note OFF Handling
   u8  RecNoteBuff   [8]      = {24,48,60,0,0,0,0,0};  //Save Incoming 8xPoly-Notes into a temporar BUFFER...waiting to be recordet INTO SEQr-Matrix "0=No Note"  
   u8  NoteCount    = 0;        //Melody-Input-Buffer from Keyboard, in order to count note number in chord-stack
   u8  DcyTrkCount  = 0;        //count thru all tracks
   u8  DcyNteCount  = 0;        //count thru all notes
  s16  RecPitchBuff = {8192};   // 8192: inital No Pitchbend! - 2midichannels...

//Menue Store-Load Variables   
  char file_type[4] = "msp0";   // definie the Filetype which is later saved via "FILE_WriteBuffer" into the file header
   s8 statusSD;					//Status of the SDCard--connected? fat?
   s8 statusDir;			    //Status "is" your direction "sdcard/t" there?
   
   u16 SongNrLoad       = 0;				
   u16 SongNrStor       = 0;
   u8  MenueUpdateFlag  = 1;    //Flag to force the MenueUpdateCounter to count a periode of time, after the time "update the menue"
   u16 MenueUpdateCount = 0;  
   u16 SD_Load_Count    = 0;
   u16 SD_Stor_Count    = 0; 
   u16 SDCardCount      = 0;
   u16 StoreCount       = 0;
   u16 LoadCount        = 0; 
     
   u8  Update_LCD_s  = 0;        //normal LCD-Labeling in back again in secunds
   u16 Upd_LCD_count = 0;
        
  char StoreFlag   = 0;
  char LoadFlag   = 0;
  char Boot_Flag  = 1;            //Update LCDs after Startup
   u8  PCLoadFlag = 0;            //Activate Timer to Load ProgramChanges from external source after a time (2seconds)
   u16 PCLoadFlagCount = 0;       //and a timer for that
   
  char file_path[16];			  //STORE-path - Number of Pathsymbols msp/512.msp
   u8 LastButtonPressed = 0;
   

//LEDRING
    u32 IND[8] = {};
    u8 LED_RING_Common = 0;     //only to calculate   ... count thru common-pins of LED-Rings

    
//LED
    u16 Blink_Button_time [4]   = {125, 250, 500, 1000};// Setup Blink-time in milli seconds
    u16 Blink_Button_count[4]   = { 0,   0,   0,    0 }; // used as timer only (change nothing here) 
    u8 Blink_Button[4]          = { 0,   0,   0,    0 };   //0 LED-OFF, 1 LED-ON
    u8 SRIO_UpdateFlag = 0;
  char Beat_Flag = 0;

//V-LEDs-Switches...
    u8 Menue[2]   = { 1, 0 }; //I have 2 PAGE Radio-Switches...
    u8 ActualMenue     = 0;
    u8 ActualSEQ  = 0; //which loop[c].SEQ is currently editet (mostly by LCD-MENUE)


   
//Note Number > Note Name Conversion (for LCD)
   char NoteName[128][3] = {    {"C 0"},{"C#0"},{"D 0"},{"D#0"},{"E 0"},{"F 0"},{"F#0"},{"G 0"},{"G#0"},{"A0"},{"A#0"},{"B 0"},
                                {"C 1"},{"C#1"},{"D 1"},{"D#1"},{"E 1"},{"F 1"},{"F#1"},{"G 1"},{"G#1"},{"A1"},{"A#1"},{"B 1"},
                                {"C 2"},{"C#2"},{"D 2"},{"D#2"},{"E 2"},{"F 2"},{"F#2"},{"G 2"},{"G#2"},{"A2"},{"A#2"},{"B 2"},
                                {"C 3"},{"C#3"},{"D 3"},{"D#3"},{"E 3"},{"F 3"},{"F#3"},{"G 3"},{"G#3"},{"A3"},{"A#3"},{"B 3"},
                                {"C 4"},{"C#4"},{"D 4"},{"D#4"},{"E 4"},{"F 4"},{"F#4"},{"G 4"},{"G#4"},{"A4"},{"A#4"},{"B 4"},
                                {"C 5"},{"C#5"},{"D 5"},{"D#5"},{"E 5"},{"F 5"},{"F#5"},{"G 5"},{"G#5"},{"A5"},{"A#5"},{"B 5"},
                                {"C 6"},{"C#6"},{"D 6"},{"D#6"},{"E 6"},{"F 6"},{"F#6"},{"G 6"},{"G#6"},{"A6"},{"A#6"},{"B 6"},
                                {"C 7"},{"C#7"},{"D 7"},{"D#7"},{"E 7"},{"F 7"},{"F#7"},{"G 7"},{"G#7"},{"A7"},{"A#7"},{"B 7"},
                                {"C 8"},{"C#8"},{"D 8"},{"D#8"},{"E 8"},{"F 8"},{"F#8"},{"G 8"},{"G#8"},{"A8"},{"A#8"},{"B 8"},
                                {"C 9"},{"C#9"},{"D 9"},{"D#9"},{"E 9"},{"F 9"},{"F#9"},{"G 9"},{"G#9"},{"A9"},{"A#9"},{"B 9"},
                                {"C x"},{"C#x"},{"D x"},{"D#x"},{"E x"},{"F x"},{"F#x"},{"G x"}
       };   



void APP_Init(void){
    // SEQUENCER TASKS
//    MIOS32_MIDI_DirectRxCallback_Init(NOTIFY_MIDI_Rx);  
//    MIOS32_MIDI_TimeOutCallback_Init(APP_MIDI_TimeOut);  // install timeout callback function  
//    SEQ_MIDI_OUT_Init(0); // initialize MIDI handler
//    SEQ_Init (0);         // initialize sequencer
//    FILE_Init(0);         // initialize file functions  
//    
//    xTaskCreate(Decay,    (signed portCHAR *)"Decay",   256,  NULL, PRIORITY_Decay,   NULL);   // start task
//    xTaskCreate(Counter,  (signed portCHAR *)"Counter", 256,  NULL, PRIORITY_Counter, NULL);  
//    xTaskCreate(TASK_SEQ, (signed portCHAR *)"SEQ",     configMINIMAL_STACK_SIZE, NULL,   PRIORITY_TASK_SEQ, NULL);  
//       
//    xLCDSemaphore     = xSemaphoreCreateRecursiveMutex(); // create Mutex for LCD access 
//    xSDCardSemaphore 	= xSemaphoreCreateRecursiveMutex();	// create Mutex for SDC access
//
//       
//    //Get and Set Multiple LCDs
//    MUTEX_LCD_TAKE;
//      MIOS32_LCD_DeviceSet(0);
//      MIOS32_LCD_Init(0);
//      MIOS32_LCD_DeviceSet(1);
//      MIOS32_LCD_Init(0);
//      MIOS32_LCD_DeviceSet(2);
//      MIOS32_LCD_Init(0);
//    MUTEX_LCD_GIVE;	
//    
//    MIOS32_BOARD_LED_Init(0xffffffff);   // initialize all LEDs

    //initalize 8 Tracks with standard values
    u8 a;
    edit= 0x0f;
    for ( a=0; a<8; a++ )Edit_Clip(a, 0, 0);

}

void APP_Background(void){
#ifdef APP_EDIT_TEST
    edit= 0x0f;
    Edit_Clip(0, 0, 1);
    u16 c, x;
    for( c=0; c<512; c++ ) {
        MIOS32_MIDI_SendDebugMessage("PB: %d: %d to %d.", c, loop[0].PB[c] ,loop_copy.PB[c]);
        for(x=0; x<8; x++)MIOS32_MIDI_SendDebugMessage("SEQ: %d: %d to %d.", c, loop[0].SEQ[c][x] ,loop_copy.SEQ[c][x]);
        MIOS32_MIDI_SendDebugMessage("MSQ: %d: %d to %d.", c, loop[0].MSQ[c] ,loop_copy.MSQ[c]);
        MIOS32_MIDI_SendDebugMessage("leader: %d: %d to %d.", c, loop[0].leader,loop_copy.leader);
        MIOS32_MIDI_SendDebugMessage("virgin: %d: %d to %d.", c, loop[0].virgin,loop_copy.virgin);
        MIOS32_MIDI_SendDebugMessage("length: %d: %d to %d.", c, loop[0].length, loop_copy.length);
        MIOS32_MIDI_SendDebugMessage("decay: %d: %d to %d.", c, loop[0].decay, loop_copy.decay);
        MIOS32_MIDI_SendDebugMessage("rythm: %d: %d to %d.", c, loop[0].rythm, loop_copy.rythm);
        MIOS32_MIDI_SendDebugMessage("bpm: %d: %d to %d.", c, loop[0].bpm, loop_copy.bpm);
    }
#endif
    // endless loop
    while( 1 ) {}
}


void APP_Tick(void){} //@1mS rate, dont do more then 300uS!// called from main task which also handles DIN, ENC and AIN events.


void APP_MIDI_Tick(void){} //@1mS rate, dont do more then 300uS!


void APP_MIDI_NotifyPackage(mios32_midi_port_t port, mios32_midi_package_t midi_package){
  //MIOS32_LCD_CursorSet(0, 0);  MIOS32_LCD_PrintFormattedString("%d %d %d %d", port, midi_package.chn, midi_package.note, midi_package.velocity);

if (midi_package.evnt0 != 248 && midi_package.evnt0 != 187){//Midi-Clock Filter - avoid that Midiclock DataMess
  
      //Receive ProgramChange Information
      if (port == PCPortIN && PCReceive == 1) {
        //Set MidiChannel && Programchange-Channel     set Song Nr with Programchange Nr  show Page PC  setLoadProgram     LOAD command   
        if (PCChIN == 0  && midi_package.evnt0 == 192) {SongNrLoad = midi_package.evnt1; MENUE(0, 0); PCLoadFlag = 1;}
        if (PCChIN == 1  && midi_package.evnt0 == 193) {SongNrLoad = midi_package.evnt1; MENUE(0, 0); PCLoadFlag = 1;} 
        if (PCChIN == 2  && midi_package.evnt0 == 194) {SongNrLoad = midi_package.evnt1; MENUE(0, 0); PCLoadFlag = 1;}
        if (PCChIN == 3  && midi_package.evnt0 == 195) {SongNrLoad = midi_package.evnt1; MENUE(0, 0); PCLoadFlag = 1;} 
        if (PCChIN == 4  && midi_package.evnt0 == 196) {SongNrLoad = midi_package.evnt1; MENUE(0, 0); PCLoadFlag = 1;}
        if (PCChIN == 5  && midi_package.evnt0 == 197) {SongNrLoad = midi_package.evnt1; MENUE(0, 0); PCLoadFlag = 1;} 
        if (PCChIN == 6  && midi_package.evnt0 == 198) {SongNrLoad = midi_package.evnt1; MENUE(0, 0); PCLoadFlag = 1;} 
        if (PCChIN == 7  && midi_package.evnt0 == 199) {SongNrLoad = midi_package.evnt1; MENUE(0, 0); PCLoadFlag = 1;} 
        if (PCChIN == 8  && midi_package.evnt0 == 200) {SongNrLoad = midi_package.evnt1; MENUE(0, 0); PCLoadFlag = 1;} 
        if (PCChIN == 9  && midi_package.evnt0 == 201) {SongNrLoad = midi_package.evnt1; MENUE(0, 0); PCLoadFlag = 1;} 
        if (PCChIN == 10 && midi_package.evnt0 == 202) {SongNrLoad = midi_package.evnt1; MENUE(0, 0); PCLoadFlag = 1;} 
        if (PCChIN == 11 && midi_package.evnt0 == 203) {SongNrLoad = midi_package.evnt1; MENUE(0, 0); PCLoadFlag = 1;} 
        if (PCChIN == 12 && midi_package.evnt0 == 204) {SongNrLoad = midi_package.evnt1; MENUE(0, 0); PCLoadFlag = 1;} 
        if (PCChIN == 13 && midi_package.evnt0 == 205) {SongNrLoad = midi_package.evnt1; MENUE(0, 0); PCLoadFlag = 1;} 
        if (PCChIN == 14 && midi_package.evnt0 == 206) {SongNrLoad = midi_package.evnt1; MENUE(0, 0); PCLoadFlag = 1;} 
        if (PCChIN == 15 && midi_package.evnt0 == 207) {SongNrLoad = midi_package.evnt1; MENUE(0, 0); PCLoadFlag = 1;}
    
    
    //MIOS32_LCD_Clear(); //clear screen 
    //MIOS32_LCD_CursorSet(0,  0);MIOS32_LCD_PrintFormattedString("%d %d %d", midi_package.evnt0, midi_package.evnt1, midi_package.evnt2);
    //MIOS32_LCD_CursorSet(0,  1);MIOS32_LCD_PrintFormattedString("%d %d", SongNrLoad, PCPortIN);
    
    }
    
      //ReRoute PitchBend, CC & NOTE Inputs  - send them to different Functions        
      if (port==MelPortIn){//MELODY-INPUT-BUFFER////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
    
        
            //Pitchbend intbit Value Calculation
            s32 channel = 0;
            if (midi_package.evnt0 >= 224 && midi_package.evnt0 <= 239) {channel = midi_package.evnt0 - 224; //Offset to MidiChannel 0-15
                
                    if ((channel==melo_input_ch[0]) && (MelIroute[0]==1))  { //filter Pitchband-Midi-Channel 0   
                            s32 msb = midi_package.evnt2 << 7;
                            RecPitchBuff = midi_package.evnt1 + msb;}
                            
                            
                            
               else if ((channel==melo_input_ch[1]) && (MelIroute[1]==1))  { //filter Pitchband-Midi-Channel 1   
                            s32 msb = midi_package.evnt2 << 7;
                            RecPitchBuff = midi_package.evnt1 + msb;}
            }
        
    
          //Melody-Buffer
           if ((midi_package.chn==melo_input_ch[0]) && (MelIroute[0]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
              if ((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { Note_Buffer(0, midi_package.note);}
              if ( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { Note_Buffer(1, midi_package.note);}
           }

           if ((midi_package.chn==melo_input_ch[1]) && (MelIroute[1]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
              if ((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { Note_Buffer(0, midi_package.note);}
              if ( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { Note_Buffer(1, midi_package.note);}
           }

    } //END MelodyPort-Filter
  } //END MidiClock-Filter
}


static s32 APP_MIDI_TimeOut(mios32_midi_port_t port) { // parse incoming sysex stream for MIOS32 commands
  return 0; // no error
}


void APP_SRIO_ServicePrepare(void){//  L E D  /called before shift register get updates
////////////////////////////////////////////////////////////////////////////////////////
//    
//    #        #####    ###       ####     #    #    #     ###     
//    #        #        #  #      #   #    #    ##   #    #        
//    #        #####    #   #     ###      #    # #  #    #  ##    
//    #        #        #  #      #  #     #    #  # #    #   #    
//    #####    #####    ###       #   #    #    #   ##     ####    
//
//
////STEP-POSITION INDICATION////

//1. Deactivate all Leds from a Ledring
    s32 u = 0;
    for(u = 0; u < 16; u++) {MIOS32_DOUT_PinSet(u, 0);} 
  
//2. Deactivate Common-Pins from all Ledrings
    s32 v = 0;
    for(v = 0; v < 8; v++) {MIOS32_DOUT_PinSet(v+16, 1);} 

//3. Activate Common PIN
    //count thru the Ring-Common-Pins
    LED_RING_Common++; if (LED_RING_Common > 7) {LED_RING_Common = 0;}
    
    switch(LED_RING_Common) {
        case 0: if (mute[0] == 1) { MIOS32_DOUT_PinSet(16,  0);}  break;
        case 1: if (mute[1] == 1) { MIOS32_DOUT_PinSet(17,  0);}  break;            
        case 2: if (mute[2] == 1) { MIOS32_DOUT_PinSet(18,  0);}  break;            
        case 3: if (mute[3] == 1) { MIOS32_DOUT_PinSet(19,  0);}  break;
        case 4: if (mute[4] == 1) { MIOS32_DOUT_PinSet(20,  0);}  break;
        case 5: if (mute[5] == 1) { MIOS32_DOUT_PinSet(21,  0);}  break;
        case 6: if (mute[6] == 1) { MIOS32_DOUT_PinSet(22,  0);}  break;
        case 7: if (mute[7] == 1) { MIOS32_DOUT_PinSet(23,  0);}  break; 
    }

//4. Activate LED-PIN for current Step
    MIOS32_DOUT_PinSet(IND[LED_RING_Common],     1);

//5. Blinking Actual-loop[c].SEQ-Showup-Indicator
    if (ActualSEQ == 0 && LED_RING_Common == 0) {MIOS32_DOUT_PinSet(7,  Blink_Button[1]);}
    if (ActualSEQ == 1 && LED_RING_Common == 1) {MIOS32_DOUT_PinSet(7,  Blink_Button[1]);}
    if (ActualSEQ == 2 && LED_RING_Common == 2) {MIOS32_DOUT_PinSet(7,  Blink_Button[1]);}
    if (ActualSEQ == 3 && LED_RING_Common == 3) {MIOS32_DOUT_PinSet(7,  Blink_Button[1]);}
    if (ActualSEQ == 4 && LED_RING_Common == 4) {MIOS32_DOUT_PinSet(7,  Blink_Button[1]);}
    if (ActualSEQ == 5 && LED_RING_Common == 5) {MIOS32_DOUT_PinSet(7,  Blink_Button[1]);}
    if (ActualSEQ == 6 && LED_RING_Common == 6) {MIOS32_DOUT_PinSet(7,  Blink_Button[1]);}
    if (ActualSEQ == 7 && LED_RING_Common == 7) {MIOS32_DOUT_PinSet(7,  Blink_Button[1]);}

/////////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////////
//    
//    #        #####    ###        
//    #        #        #  #            
//    #        #####    #   #        
//    #        #        #  #       
//    #####    #####    ###        
//
//

//MENUE-LEDs
if (ActualMenue == 0){
    if (SRIO_UpdateFlag == 0) {
        SRIO_UpdateFlag = 1; //RESET FLAG
        
    //Indicate the PageGroup 0
        MIOS32_DOUT_PinSet(40, 0);  //Turn OFF Menue[1] Bank - LEDs
        MIOS32_DOUT_PinSet(41, 0);  //Turn OFF Menue[1] Bank - LEDs
        MIOS32_DOUT_PinSet(42, 0);  //Turn OFF Menue[1] Bank - LEDs                              
        MIOS32_DOUT_PinSet(43, 0);  //Turn OFF Menue[1] Bank - LEDs 
 
        switch(Menue[0])    {       //Turn ON/OFF Menue[0] Bank - LEDs
            case 0:         MIOS32_DOUT_PinSet(32, 1); 
                            MIOS32_DOUT_PinSet(33, 0);
                            MIOS32_DOUT_PinSet(34, 0);                         
                            MIOS32_DOUT_PinSet(35, 0);  break;
    
            case 1:         MIOS32_DOUT_PinSet(32, 0);
                            MIOS32_DOUT_PinSet(33, 1);
                            MIOS32_DOUT_PinSet(34, 0);                              
                            MIOS32_DOUT_PinSet(35, 0);  break;
    
            case 2:         MIOS32_DOUT_PinSet(32, 0);
                            MIOS32_DOUT_PinSet(33, 0);
                            MIOS32_DOUT_PinSet(34, 1);                              
                            MIOS32_DOUT_PinSet(35, 0);  break;
    
            case 3:         MIOS32_DOUT_PinSet(32, 0);
                            MIOS32_DOUT_PinSet(33, 0);
                            MIOS32_DOUT_PinSet(34, 0);                              
                            MIOS32_DOUT_PinSet(35, 1);  break;
                            }
      }

    
    if (Menue[0] == 0){
      //1st Line of Virtual-LEDs
      MIOS32_DOUT_PinSet( 48, Blink_Button[2]);
      MIOS32_DOUT_PinSet( 49, Blink_Button[2]); 
      MIOS32_DOUT_PinSet( 50, Blink_Button[2]);    
      MIOS32_DOUT_PinSet( 51, Blink_Button[2]);     
      MIOS32_DOUT_PinSet( 52, Blink_Button[2]); 	       
      MIOS32_DOUT_PinSet( 53, Blink_Button[2]);      
      MIOS32_DOUT_PinSet( 54, Blink_Button[2]);       
      MIOS32_DOUT_PinSet( 55, Blink_Button[2]);
      //2nd Line of Virtual-LEDs
      MIOS32_DOUT_PinSet( 56, REC[0]);
      MIOS32_DOUT_PinSet( 57, REC[1]); 
      MIOS32_DOUT_PinSet( 58, REC[2]);        
      MIOS32_DOUT_PinSet( 59, REC[3]);        
      MIOS32_DOUT_PinSet( 60, REC[4]);        
      MIOS32_DOUT_PinSet( 61, REC[5]); 
      MIOS32_DOUT_PinSet( 62, REC[6]);                                                     
      MIOS32_DOUT_PinSet( 63, REC[7]);}

    if (Menue[0] == 1){ // Start, Stop, BPM, 4/4 5/4..., Store Load
      //1st Line of Virtual-LEDs
        //The Last pressed Button should blink
        MIOS32_DOUT_PinSet( LastButtonPressed+48, Blink_Button[1]);      
      
        //SEQ-Is-Running-LED
        if ( SEQ_BPM_IsRunning()==1 ) {MIOS32_DOUT_PinSet(48,1);
                                       MIOS32_DOUT_PinSet(56,0);}
        else                          {MIOS32_DOUT_PinSet(48,0);
                                       MIOS32_DOUT_PinSet(56,1);}}

    if (Menue[0] == 2){ // COPY - PASTE
      // Indicate Actual Sequence to edit
      if (ActualSEQ == 0) {MIOS32_DOUT_PinSet( 48, Blink_Button[2]);}
                      else{MIOS32_DOUT_PinSet( 48, 0);}
      if (ActualSEQ == 1) {MIOS32_DOUT_PinSet( 49, Blink_Button[2]);}
                      else{MIOS32_DOUT_PinSet( 49, 0);}
      if (ActualSEQ == 2) {MIOS32_DOUT_PinSet( 50, Blink_Button[2]);}
                      else{MIOS32_DOUT_PinSet( 50, 0);} 
      if (ActualSEQ == 3) {MIOS32_DOUT_PinSet( 51, Blink_Button[2]);}
                      else{MIOS32_DOUT_PinSet( 51, 0);} 
      if (ActualSEQ == 4) {MIOS32_DOUT_PinSet( 52, Blink_Button[2]);}
                      else{MIOS32_DOUT_PinSet( 52, 0);} 
      if (ActualSEQ == 5) {MIOS32_DOUT_PinSet( 53, Blink_Button[2]);}
                      else{MIOS32_DOUT_PinSet( 53, 0);} 
      if (ActualSEQ == 6) {MIOS32_DOUT_PinSet( 54, Blink_Button[2]);}
                      else{MIOS32_DOUT_PinSet( 54, 0);} 
      if (ActualSEQ == 7) {MIOS32_DOUT_PinSet( 55, Blink_Button[2]);}
                      else{MIOS32_DOUT_PinSet( 55, 0);}   

      //2nd Line of Virtual-LEDs    --- do things- - copy paste

      MIOS32_DOUT_PinSet( 56, edit & 0x01);
      MIOS32_DOUT_PinSet( 57, (edit>>1) & 1);
      MIOS32_DOUT_PinSet( 58, (edit>>2) & 1);
      MIOS32_DOUT_PinSet( 59, (edit>>1) & 1);

      MIOS32_DOUT_PinSet( 60, Blink_Button[2]);
      MIOS32_DOUT_PinSet( 61, Blink_Button[2]); 
      MIOS32_DOUT_PinSet( 62, Blink_Button[2]);                                                     
      MIOS32_DOUT_PinSet( 63, Blink_Button[3]);}
}

//MENUE-LEDs
if (ActualMenue == 1) {
    if (SRIO_UpdateFlag == 0) {
        SRIO_UpdateFlag = 1; //RESET FLAG
        
        
    //Indicate the PageGroup 0
        MIOS32_DOUT_PinSet(32, 0);  //Turn OFF Menue[0] Bank - LEDs
        MIOS32_DOUT_PinSet(33, 0);  //Turn OFF Menue[0] Bank - LEDs
        MIOS32_DOUT_PinSet(34, 0);  //Turn OFF Menue[0] Bank - LEDs                              
        MIOS32_DOUT_PinSet(35, 0);  //Turn OFF Menue[0] Bank - LEDs 
 
        switch(Menue[1])    {       //Turn ON/OFF Menue[1] Bank - LEDs
            case 0:         MIOS32_DOUT_PinSet(40, 1); 
                            MIOS32_DOUT_PinSet(41, 0);
                            MIOS32_DOUT_PinSet(42, 0);                         
                            MIOS32_DOUT_PinSet(43, 0);  break;

            case 1:         MIOS32_DOUT_PinSet(40, 0); 
                            MIOS32_DOUT_PinSet(41, 1);
                            MIOS32_DOUT_PinSet(42, 0);                         
                            MIOS32_DOUT_PinSet(43, 0);  break;
                            
            case 2:         MIOS32_DOUT_PinSet(40, 0); 
                            MIOS32_DOUT_PinSet(41, 0);
                            MIOS32_DOUT_PinSet(42, 1);                         
                            MIOS32_DOUT_PinSet(43, 0);  break;

            case 3:         MIOS32_DOUT_PinSet(40, 0); 
                            MIOS32_DOUT_PinSet(41, 0);
                            MIOS32_DOUT_PinSet(42, 0);                         
                            MIOS32_DOUT_PinSet(43, 1);  break;
                            }
                }


    if (Menue[1] == 0) {
      //1st Line of Virtual-LEDs
      MIOS32_DOUT_PinSet( 48, mute[0]);
      MIOS32_DOUT_PinSet( 49, mute[1]); 
      MIOS32_DOUT_PinSet( 50, mute[2]);    
      MIOS32_DOUT_PinSet( 51, mute[3]);     
      MIOS32_DOUT_PinSet( 52, mute[4]); 	       
      MIOS32_DOUT_PinSet( 53, mute[5]);      
      MIOS32_DOUT_PinSet( 54, mute[6]);       
      MIOS32_DOUT_PinSet( 55, mute[7]);
      //2nd Line of Virtual-LEDs
      MIOS32_DOUT_PinSet( 56, REC[0]);
      MIOS32_DOUT_PinSet( 57, REC[1]); 
      MIOS32_DOUT_PinSet( 58, REC[2]);        
      MIOS32_DOUT_PinSet( 59, REC[3]);        
      MIOS32_DOUT_PinSet( 60, REC[4]);        
      MIOS32_DOUT_PinSet( 61, REC[5]); 
      MIOS32_DOUT_PinSet( 62, REC[6]);                                                     
      MIOS32_DOUT_PinSet( 63, REC[7]);}
      
    if (Menue[1] == 1) {
      //1st Line of Virtual-LEDs
      MIOS32_DOUT_PinSet( 48, REC_PB_with_Notes[0]);
      MIOS32_DOUT_PinSet( 49, REC_PB_with_Notes[1]); 
      MIOS32_DOUT_PinSet( 50, REC_PB_with_Notes[2]);    
      MIOS32_DOUT_PinSet( 51, REC_PB_with_Notes[3]);     
      MIOS32_DOUT_PinSet( 52, REC_PB_with_Notes[4]); 	       
      MIOS32_DOUT_PinSet( 53, REC_PB_with_Notes[5]);      
      MIOS32_DOUT_PinSet( 54, REC_PB_with_Notes[6]);       
      MIOS32_DOUT_PinSet( 55, REC_PB_with_Notes[7]);
      //2nd Line of Virtual-LEDs
      MIOS32_DOUT_PinSet( 56, REC_PB[0]);
      MIOS32_DOUT_PinSet( 57, REC_PB[1]); 
      MIOS32_DOUT_PinSet( 58, REC_PB[2]);        
      MIOS32_DOUT_PinSet( 59, REC_PB[3]);        
      MIOS32_DOUT_PinSet( 60, REC_PB[4]);        
      MIOS32_DOUT_PinSet( 61, REC_PB[5]); 
      MIOS32_DOUT_PinSet( 62, REC_PB[6]);                                                     
      MIOS32_DOUT_PinSet( 63, REC_PB[7]);}      
}

//SEQ-Is-Running-LED
if (SEQ_BPM_IsRunning()==0) { MIOS32_DOUT_PinSet(37,1);}//Play LED Deactive 
                      else { if (Beat_Flag == 0)   { MIOS32_DOUT_PinSet(37,0);} //Play LED ACTIVE
                             else {MIOS32_DOUT_PinSet(37,1); }//Play LED Deactive
                            }
}	
    
    
void APP_SRIO_ServiceFinish(void){} //called after shift register chain was scanned


void APP_DIN_NotifyToggle(u32 pin, u32 pin_value){
    
    if (pin_value == 0) {
            
         switch(pin) { //Bank Buttons, and Actual Track Indication, Rerouting of pins
       
            //Bank Button
            case  0:    //Button-Bank-Switch 0  to  switch between Pages of Actual BANK 0
                        if (ActualMenue != 0) {ActualMenue = 0; MenueUpdateFlag=0;}
                        else  { Menue[0]++;    //count thru the pages
                                if (Menue[0] <= 0)  {Menue[0] = 0;};
                                if (Menue[0] >  3)  {Menue[0] = 0;}; 
                                MenueUpdateFlag=0;}   
                        pin = 80;
                                                    break;          
                        
            case  1:    //Button-Bank-Switch 0  to  switch between Pages of Actual BANK 0
                        if (ActualMenue != 1) {ActualMenue = 1; MenueUpdateFlag=0;}
                        else  { Menue[1]++;    //count thru the pages
                                if (Menue[1] <= 0)  {Menue[1] = 0;};
                                if (Menue[1] >  3)  {Menue[1] = 0;}; 
                                MenueUpdateFlag=0;}
                        pin = 81;
                                                    break;              
                                        
            //16x Button
            case  8:     pin = 0;    break;
            case  9:     pin = 1;    break;
            case 10:     pin = 2;    break;
            case 11:     pin = 3;    break;
            case 12:     pin = 4;    break;
            case 13:     pin = 5;    break;
            case 14:     pin = 6;    break;
            case 15:     pin = 7;    break;
            case 16:     pin = 8;    break;
            case 17:     pin = 9;    break;
            case 18:     pin = 10;   break;
            case 19:     pin = 11;   break;
            case 20:     pin = 12;   break;
            case 21:     pin = 13;   break;
            case 22:     pin = 14;   break;
            case 23:     pin = 15;   break;
            
            }
            
    // Set Actual Sequence Nr        
    if (      (   (ActualMenue==0)  &&  (pin < 16)  &&  ( (Menue[0]==2) || (Menue[0]==3) )   )                                     //ACTUAL-PIN
          ||  (   (ActualMenue==1)  &&  (pin < 16)  &&  ( (Menue[1]==0) || (Menue[1]==1) || (Menue[1]==2) || (Menue[1]==3) )))   { ActualSEQ = pin; }
    
    // Last Button Pressed?
    if (pin < 16) { LastButtonPressed = pin ;}
    
    ////////////////////////////////////////////////////////////////
    //                                                            //
    //  M       E     EEEEEEE    N     N     U     U     EEEEEEE  //                                                                
    //  M E   U E     E          N N   N     U     U     E        //                                                          
    //  M   N   E     EEEE       N  N  N     U     U     EEEE     //                                                          
    //  M       E     E          N   N N     U     U     E        //                                                          
    //  M       E     EEEEEEE    N    NN     UUUUUUU     EEEEEEE  //                                                  
    //                                                            //
    
    ////////////////////////////////////////////////////////////////                          
    //Upper Pages
    if (ActualMenue == 0) {  
                        
        //Page 0 - Looplength , Record Notes
        if (Menue[0] == 0) {
            
            switch (pin) { //Loop Length  +++  Record-Buttons
                //LOOP-LENGTH-BLOCK      \/Double LoopLength on LCD                       ----      Set new Loop-Length   &   Change in SYNC
                case 0:     loop[0].length = loop[0].length  * 2;   if (loop[0].length > MainLoop*2)  {loop[0].length  = 1;    Loop[0] = loop[0].length * MainLoop;    NeedSync = 1;};    MenueUpdateFlag=0;   break; //new Loop point 
                case 1:     loop[1].length = loop[1].length  * 2;   if (loop[1].length > MainLoop*2)  {loop[1].length  = 1;    Loop[1] = loop[1].length * MainLoop;    NeedSync = 1;};    MenueUpdateFlag=0;   break; //when MainLoop is finished}}
                case 2:     loop[2].length = loop[2].length  * 2;   if (loop[2].length > MainLoop*2)  {loop[2].length  = 1;    Loop[2] = loop[2].length * MainLoop;    NeedSync = 1;};    MenueUpdateFlag=0;   break; 
                case 3:     loop[3].length = loop[3].length  * 2;   if (loop[3].length > MainLoop*2)  {loop[3].length  = 1;    Loop[3] = loop[3].length * MainLoop;    NeedSync = 1;};    MenueUpdateFlag=0;   break; 
                case 4:     loop[4].length = loop[4].length  * 2;   if (loop[4].length > MainLoop*2)  {loop[4].length  = 1;    Loop[4] = loop[4].length * MainLoop;    NeedSync = 1;};    MenueUpdateFlag=0;   break; 
                case 5:     loop[5].length = loop[5].length  * 2;   if (loop[5].length > MainLoop*2)  {loop[5].length  = 1;    Loop[5] = loop[5].length * MainLoop;    NeedSync = 1;};    MenueUpdateFlag=0;   break; 
                case 6:     loop[6].length = loop[6].length  * 2;   if (loop[6].length > MainLoop*2)  {loop[6].length  = 1;    Loop[6] = loop[6].length * MainLoop;    NeedSync = 1;};    MenueUpdateFlag=0;   break; 
                case 7:     loop[7].length = loop[7].length  * 2;   if (loop[7].length > MainLoop*2)  {loop[7].length  = 1;    Loop[7] = loop[7].length * MainLoop;    NeedSync = 1;};    MenueUpdateFlag=0;   break; 
                //Record-Block
                case  8:    REC[0]  =! REC[0];     if (REC[0] > 1)  {REC[0]  = 1;}; break;
                case  9:    REC[1]  =! REC[1];     if (REC[1] > 1)  {REC[1]  = 1;}; break;
                case 10:    REC[2]  =! REC[2];     if (REC[2] > 1)  {REC[2]  = 1;}; break;
                case 11:    REC[3]  =! REC[3];     if (REC[3] > 1)  {REC[3]  = 1;}; break;
                case 12:    REC[4]  =! REC[4];     if (REC[4] > 1)  {REC[4]  = 1;}; break;
                case 13:    REC[5]  =! REC[5];     if (REC[5] > 1)  {REC[5]  = 1;}; break;
                case 14:    REC[6]  =! REC[6];     if (REC[6] > 1)  {REC[6]  = 1;}; break;
                case 15:    REC[7]  =! REC[7];     if (REC[7] > 1)  {REC[7]  = 1;}; break;
            }
        }

  
        //Page 1 - Start-Stop Internal Clock   -    Beat-Structure  SET  4/4 5/4 6/4 7/4 9/4...   -   Record-Settings
        if (Menue[0] == 1) {
            
            switch(pin) {
                
                case 0:     SEQ_BPM_Start();                    break;
                case 8:     SEQ_BPM_Stop();     SEQ_Init(0);    break;
                
                case 1:     loop[ActualSEQ].bpm = loop[ActualSEQ].bpm +20;  
                            if ( (loop[ActualSEQ].bpm > 240) ) {loop[ActualSEQ].bpm = 20;}  
                            SEQ_BPM_Set(loop[ActualSEQ].bpm);    
                            NeedSync = 1;       
                            MenueUpdateFlag=0;  break;
                            
                case 9:     loop[ActualSEQ].bpm  =  loop[ActualSEQ].bpm -1;   
                            if (loop[ActualSEQ].bpm < 1)  { loop[ActualSEQ].bpm = 1; }  
                            SEQ_BPM_Set( loop[ActualSEQ].bpm );    
                            NeedSync = 1;       
                            MenueUpdateFlag=0;  break;
                
                case 2:     loop[ActualSEQ].rythm++;  
                            if (loop[ActualSEQ].rythm  <  2) {loop[ActualSEQ].rythm = 2;}
                            if (loop[ActualSEQ].rythm  > 16) {loop[ActualSEQ].rythm = 2;}
                            NeedSync = 1;                               MenueUpdateFlag=0;  break;   
                            
                case 3:     RecOffset++;    if (RecOffset >= 4)     {RecOffset = 0;}        MenueUpdateFlag=0; break;  
                
                case 4:     SongNrStor++;   if (SongNrStor > 126)   {SongNrStor = 127;}     MenueUpdateFlag=0;  break;
                            
                case 12:    SongNrStor--; 
                            if (SongNrStor <   0) {SongNrStor = 0;}   
                            if (SongNrStor >  127){SongNrStor = 0;}      MenueUpdateFlag=0;  break;

                case 5:     SongNrLoad++;   if (SongNrLoad > 126)    {SongNrLoad = 127;}     MenueUpdateFlag=0;  break;
                            
                case 13:    SongNrLoad--; 
                            if (SongNrLoad <   0) {SongNrLoad = 0;}   
                            if (SongNrLoad >  127){SongNrLoad = 0;}      MenueUpdateFlag=0;  break;
                            
                            //Store/load @ ProgramChange
                case 6:     StoreFlag = 1; break;         //Job1=load, Job2=store, Job3=initalize card 
                
                case 14:    LoadFlag  = 1; break;         //Job1=load, Job2=store, Job3=initalize card 
                                    
            }
        }

        //Page 2 - Copy Paste Clear    C L I P S
        if (Menue[0] == 2) {
            
            switch(pin) {
                
//                case  8:    edit[0] =! edit[0];         break;  // Act on: PB
//                case  9:    edit[1] =! edit[1];         break;  // Act on: SEQ
//                case 10:    edit[2] =! edit[2];         break;  // Act on: MSQ-CC
//                case 11:    edit[3] =! edit[3];         break;  // Act on: Beat structure like Loop Length BPM and so on
                case  8:    edit ^= (1<<0);         break;  // Act on: PB
                case  9:    edit ^= (1<<1);         break;  // Act on: SEQ
                case 10:    edit ^= (1<<2);         break;  // Act on: MSQ-CC
                case 11:    edit ^= (1<<3);         break;  // Act on: Beat structure like Loop Length BPM and so on
                    
                case 12:    Edit_Clip(ActualSEQ, 0, 0); break;  // Clear
                case 13:    Edit_Clip(ActualSEQ, 0, 1); break;  // Copy
                case 14:    Edit_Clip(ActualSEQ, 0, 2); break;  // Paste
                case 15:    NeedSync = 1;               break;  // Syncronize Loops when loading BPM Structure
 }
}

    }
    
    /////////////////////////////////////////////////////////////////
    //Lower Pages
    if (ActualMenue == 1) {  
                        
        //Page 0 - MUTE and REC Pitchbend+Notes (Pitchebend only if activated in next menue)
        if (Menue[1] == 0) {    
            
            switch(pin) {
                //Mute-Block
                case 0:     mute[0] =! mute[0];    if (mute[0] > 1) {mute[0] = 1;}; break;
                case 1:     mute[1] =! mute[1];    if (mute[1] > 1) {mute[1] = 1;}; break;
                case 2:     mute[2] =! mute[2];    if (mute[2] > 1) {mute[2] = 1;}; break;
                case 3:     mute[3] =! mute[3];    if (mute[3] > 1) {mute[3] = 1;}; break;
                case 4:     mute[4] =! mute[4];    if (mute[4] > 1) {mute[4] = 1;}; break;
                case 5:     mute[5] =! mute[5];    if (mute[5] > 1) {mute[5] = 1;}; break;
                case 6:     mute[6] =! mute[6];    if (mute[6] > 1) {mute[6] = 1;}; break;
                case 7:     mute[7] =! mute[7];    if (mute[7] > 1) {mute[7] = 1;}; break;
                //Record-Block
                case  8:    REC[0]  =! REC[0];      if (REC[0] > 1)  {REC[0]  = 1;}; break;
                case  9:    REC[1]  =! REC[1];      if (REC[1] > 1)  {REC[1]  = 1;}; break;
                case 10:    REC[2]  =! REC[2];      if (REC[2] > 1)  {REC[2]  = 1;}; break;
                case 11:    REC[3]  =! REC[3];      if (REC[3] > 1)  {REC[3]  = 1;}; break;
                case 12:    REC[4]  =! REC[4];      if (REC[4] > 1)  {REC[4]  = 1;}; break;
                case 13:    REC[5]  =! REC[5];      if (REC[5] > 1)  {REC[5]  = 1;}; break;
                case 14:    REC[6]  =! REC[6];      if (REC[6] > 1)  {REC[6]  = 1;}; break;
                case 15:    REC[7]  =! REC[7];      if (REC[7] > 1)  {REC[7]  = 1;}; break;
            }
        }

        //Page 0 - PB-RECORD-Mode + Pitchbend Record only
        if (Menue[1] == 1) {    
            
            switch(pin) {
                //Mute-Block
                case 0:     REC_PB_with_Notes[0] =! REC_PB_with_Notes[0];    if (REC_PB_with_Notes[0] > 1) {REC_PB_with_Notes[0] = 1;}; break;
                case 1:     REC_PB_with_Notes[1] =! REC_PB_with_Notes[1];    if (REC_PB_with_Notes[1] > 1) {REC_PB_with_Notes[1] = 1;}; break;
                case 2:     REC_PB_with_Notes[2] =! REC_PB_with_Notes[2];    if (REC_PB_with_Notes[2] > 1) {REC_PB_with_Notes[2] = 1;}; break;
                case 3:     REC_PB_with_Notes[3] =! REC_PB_with_Notes[3];    if (REC_PB_with_Notes[3] > 1) {REC_PB_with_Notes[3] = 1;}; break;
                case 4:     REC_PB_with_Notes[4] =! REC_PB_with_Notes[4];    if (REC_PB_with_Notes[4] > 1) {REC_PB_with_Notes[4] = 1;}; break;
                case 5:     REC_PB_with_Notes[5] =! REC_PB_with_Notes[5];    if (REC_PB_with_Notes[5] > 1) {REC_PB_with_Notes[5] = 1;}; break;
                case 6:     REC_PB_with_Notes[6] =! REC_PB_with_Notes[6];    if (REC_PB_with_Notes[6] > 1) {REC_PB_with_Notes[6] = 1;}; break;
                case 7:     REC_PB_with_Notes[7] =! REC_PB_with_Notes[7];    if (REC_PB_with_Notes[7] > 1) {REC_PB_with_Notes[7] = 1;}; break;
                //Record-Block
                case  8:    REC_PB[0]  =! REC_PB[0];      if (REC_PB[0] > 1)  {REC_PB[0]  = 1;}; break;
                case  9:    REC_PB[1]  =! REC_PB[1];      if (REC_PB[1] > 1)  {REC_PB[1]  = 1;}; break;
                case 10:    REC_PB[2]  =! REC_PB[2];      if (REC_PB[2] > 1)  {REC_PB[2]  = 1;}; break;
                case 11:    REC_PB[3]  =! REC_PB[3];      if (REC_PB[3] > 1)  {REC_PB[3]  = 1;}; break;
                case 12:    REC_PB[4]  =! REC_PB[4];      if (REC_PB[4] > 1)  {REC_PB[4]  = 1;}; break;
                case 13:    REC_PB[5]  =! REC_PB[5];      if (REC_PB[5] > 1)  {REC_PB[5]  = 1;}; break;
                case 14:    REC_PB[6]  =! REC_PB[6];      if (REC_PB[6] > 1)  {REC_PB[6]  = 1;}; break;
                case 15:    REC_PB[7]  =! REC_PB[7];      if (REC_PB[7] > 1)  {REC_PB[7]  = 1;}; break;
            }
        }        
    }
    
    //Update UI
    SRIO_UpdateFlag=0; //activate 
    }
}


void APP_ENC_NotifyChange(u32 encoder, s32 incrementer){}


static void TASK_SEQ(void *pvParameters){ //called periodically each mS to handle sequencer requests
  portTickType xLastExecutionTime;

  // Initialise the xLastExecutionTime variable on task entry
  xLastExecutionTime = xTaskGetTickCount();

  while( 1 ) {
    vTaskDelayUntil(&xLastExecutionTime, 1 / portTICK_RATE_MS);

    // execute sequencer handler
    SEQ_Handler();

  }
}

static s32 NOTIFY_MIDI_Rx(mios32_midi_port_t port,  u8 midi_byte){//filter Midiclock Port and rerout it to SEQUENCER-BPM
if (port == ClockPortIN) { SEQ_BPM_NotifyMIDIRx(midi_byte); }
  return 0; // no error, no filtering
}


///////////////////////////////////////////////
//Melody-Out-Generation - via incoming sequence
u8 REC_PLAY(u8 port, u8 note, u8 velocity, u16 step, u16 tic){ //do triggering

if (port == 0) { //Messages from loop[c].SEQr-Tic and Steps

////////////////////////////////////////////////////////////////////////////////////////
//    
//    ####     #####     ####    
//    #   #    #        #        
//    ###      ###      #    
//    #  #     #        #       
//    #   #    #####     ####  
//
////////////////////////////////////////////////////////////////////

    // Write Notes in currently played Step 
    if (tic <= 48 )  {      u8 c;	for(c=0; c<8; ++c) {  // Count-thru-Tracks [0] [1] [2] [3] [4] [5] [6] [7] 
            
            if( (REC[c] == 1) || (REC_PB[c] == 1) ) { // Calculate Step-Offset
                // REC Notes  a  few steps behind,     to note Machine-Delay,      Human Delay and so on         
                RecOffsetCalc = loop_step_pos[c] - RecOffset;
                if (RecOffsetCalc < 0)                            { RecOffsetCalc = (loop[c].length * MainLoop) - RecOffsetCalc; } 
                if (RecOffsetCalc > (loop[c].length * MainLoop))  { RecOffsetCalc =  RecOffsetCalc  - (loop[c].length * MainLoop); }
            }
            // Write Notes  in  played Step
            if(  REC[c] == 1)  { u8 x=0;	for(x=0; x<8; ++x)  { loop[c].SEQ [RecOffsetCalc] [x] = RecNoteBuff[x]; };   }
    
            // Write Pitchbend in played Step    
            if(   ( (REC[c] == 1) && (REC_PB_with_Notes[c]==1) )   ||   (REC_PB[c] == 1) )  { loop[c].PB [RecOffsetCalc] = RecPitchBuff; }                            
        }}
               
                 
    // UP-QUANTIZE > Write Notes into Next Step                  
    else {                  u8 c;	for(c=0; c<8; ++c)  {  // Count-thru-Tracks [0] [1] [2] [3] [4] [5] [6] [7]     

            if( (REC[c] == 1) || (REC_PB[c] == 1) ) { // Calculate Step-Offset
                // REC Notes  a  few steps behind,     to note Machine-Delay,      Human Delay and so on
                RecOffsetCalc = loop_step_pos[c] - RecOffset + 1;
                if (RecOffsetCalc < 0)  {RecOffsetCalc = (loop[c].length * MainLoop) - RecOffsetCalc;} 
                if (RecOffsetCalc > (loop[c].length * MainLoop))  {RecOffsetCalc = RecOffsetCalc - (loop[c].length * MainLoop);}
            }
            // Write Notes into next Step
            if(  REC[c] == 1)  { u8 x=0;	for(x=0; x<8; ++x)  { loop[c].SEQ [RecOffsetCalc] [x] = RecNoteBuff[x]; };   }
            
            // Write Pitchbend into next Step    
            if(   ( (REC[c] == 1) && (REC_PB_with_Notes[c] == 1) )   ||   (REC_PB[c] == 1) )  { loop[c].PB [RecOffsetCalc] = RecPitchBuff; }  
        }}    
    
////////////////////////////////////////////////////////////////////////////////////////
//    
//    #####      ####     #     ###     
//      #        #   #    #    #        
//      #        ###      #    #  ##    
//      #        #  #     #    #   #    
//      #        #   #    #    #####    
//
////////////////////////////////////////////////////////////////////
if (MainDelay  == tic) {          u8 trigNr=0;	for(trigNr=0; trigNr<8; ++trigNr) {  //Trigger [0] - [7]  
                 
       if ( (mute[trigNr]==1) &&  //ACTIVATE Button 
            (   (loop[trigNr].SEQ [loop_step_pos[trigNr]] [0] > 0)  || //any Note in loop[trigNr].SEQr Step? Right Tic?
                (loop[trigNr].SEQ [loop_step_pos[trigNr]] [1] > 0)  ||
                (loop[trigNr].SEQ [loop_step_pos[trigNr]] [2] > 0)  ||
                (loop[trigNr].SEQ [loop_step_pos[trigNr]] [3] > 0)  ||
                (loop[trigNr].SEQ [loop_step_pos[trigNr]] [4] > 0)  ||
                (loop[trigNr].SEQ [loop_step_pos[trigNr]] [5] > 0)  ||
                (loop[trigNr].SEQ [loop_step_pos[trigNr]] [6] > 0)  ||
                (loop[trigNr].SEQ [loop_step_pos[trigNr]] [7] > 0)  ||
                ((REC[trigNr] == 1) && (MainDelay == tic))
            )   )
         {  //send Poly Melody NoteOut
                    
                if (REC[trigNr] == 0) { //Trigger actual step
                    int buf;	for(buf=0; buf<8; ++buf) {                     

                            if (loop[trigNr].SEQ[loop_step_pos[trigNr]][buf] > 0) {
                                
                                MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[trigNr], loop[trigNr].SEQ[loop_step_pos[trigNr]][buf], 127); 
                                
                                MeloDecayTIMER  [trigNr]  [ loop[trigNr].SEQ[loop_step_pos[trigNr]] [buf] ]  = loop[trigNr].decay;
                                } 
                    }
                                            //if (RecPitchBuff =! 8192) { //send Pitchbend-Values only if they are
                            MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[trigNr], loop[trigNr].PB[loop_step_pos[trigNr]]);
                                
                                 
                }               
                
                if (REC[trigNr] == 1) { //Trigger while recording
                    u8 c;	for(c=0; c<8; ++c) {                     

                            if (RecNoteBuff[c] > 0) {
                                
                                MIOS32_MIDI_SendNoteOn(MelPortOut, MeloOutCh[trigNr], RecNoteBuff[c], 127); 
                                
                                MeloDecayTIMER  [ trigNr ]  [ RecNoteBuff[c] ]  =  loop[c].decay;}

                            MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[trigNr], RecPitchBuff);
                    }               }   
        }

}}




//MENU PAGE: chord-display
//if ( (tic == 60) && (Menue[1] == 0) && (ActualMenue == 1) ) { MENUE(125, 0);}     //update MENUE after a while...but only by tic 20 in order to get more CPU-time...   
}        
//Beat LED
if (tic > 0)     {Beat_Flag = 0;}//Play LED Deactive
else            {Beat_Flag = 1;};    

  return 0; // no error,
}


// S T O R A G E - SD - C A R D      ///  read write clips/programchanges
static void SD(u8 track, u16 clip, u16 job){         //Job1=load all, Job2=store all, Job3=initalize card
    u16 t = 0; //track counter initation
    
    switch(job) {   
 
// R E A D /////////////////////////////////////////////////////////////////////////////////////////////////////// 
          
            case 1: //LOAD single Clip
                        MUTEX_SDCARD_TAKE;  
                            sprintf         ( file_path, "msp/%d-%d.msp", track, clip );
                            FILE_ReadOpen   ( &midifile_fi, file_path );
                            FILE_ReadBuffer ( (u8 *)&file_type, 4 ); 
                            FILE_ReadBuffer ( (u8 *)&loop[track], sizeof(store_t) );   
                            FILE_ReadClose  ( &midifile_fi );
                        MUTEX_SDCARD_GIVE;      
                        
                        //Calculate new Loop Lengths
                        Loop[track]         = loop[track].length * MainLoop;
                        
    
                        //SEQ_BPM_Set(loop[c].bpm);
                        NeedSync = 1; //update ClockCounter when ready...
               
                        SongNrStor = SongNrLoad; //transfair load nr 2 store nr.
                    break;
                    
            case 2: //LOAD all Clips - FOR  P R O G R A M  C H A N G E
                          for( t=0; t<8; t++) { 
                                MUTEX_SDCARD_TAKE;  
                                    sprintf         ( file_path, "msp/%d-%d.msp", t, clip );
                                    FILE_ReadOpen   ( &midifile_fi, file_path );
                                    FILE_ReadBuffer ( (u8  *)&file_type, 4 ); 
                                    FILE_ReadBuffer ( (u8  *)&loop[t], sizeof(store_t) );   
                                    FILE_ReadClose  ( &midifile_fi );
                                MUTEX_SDCARD_GIVE;                        
                                
                                //Calculate new Loop Lengths
                                Loop[t]         = loop[t].length * MainLoop;
                        }
                            


                        //SEQ_BPM_Set(loop[c].bpm);
                        NeedSync = 1; //update ClockCounter when ready...
               
                        SongNrStor = SongNrLoad; //transfair load nr 2 store nr.
                        
                        MUTEX_LCD_TAKE; 
                            MIOS32_LCD_DeviceSet(2); MIOS32_LCD_Clear(); MIOS32_LCD_CursorSet(0, 0); 
                            MIOS32_LCD_PrintFormattedString	("%s", "PROGRAM LOAD - Finished");
                        MUTEX_LCD_GIVE; 
                        
                        Update_LCD_s = 1; //normal LCD-Labeling in back again in a second
                    break;
                	
                    
// S T O R E /////////////////////////////////////////////////////////////////////////////////////////////////////               
  
            case 3: //S T O R E Single Clip

                                MUTEX_SDCARD_TAKE;
                                        //Write to File
                                        sprintf(file_path, "msp/%d-%d.msp", track, clip);             
                                        FILE_WriteOpen	( file_path,          16 );   
                                        FILE_WriteBuffer( (u8  *)&file_type,   4 ); //"SIGL" = 4 Positons                                                     
                                        FILE_WriteBuffer( (u8  *)&loop[track], sizeof(store_t) );                                      
                                        FILE_WriteClose	(); 
                                MUTEX_SDCARD_GIVE;  //SD-Card is now free 4 access
                                
                                Update_LCD_s = 1; //normal LCD-Labeling in back again in secunds
                                
                                SongNrLoad = SongNrStor; //transfair load nr 2 store nr.
                    break;
                                
            case 4: //S T O R E all Clips - FOR  P R O G R A M  C H A N G E
                    
                        for( t=0; t<8; t++)     { // store file once  by once
                                
                                MUTEX_SDCARD_TAKE;
                                        //Write to File
                                        sprintf             ( file_path, "msp/%d-%d.msp", t, clip);             
                                            FILE_WriteOpen	( file_path,               16 );               
                                            FILE_WriteBuffer( (u8  *)&file_type,        4 );  
                                            FILE_WriteBuffer( (u8  *)&loop[t], sizeof(store_t) );    
                                        FILE_WriteClose	(); 
                                MUTEX_SDCARD_GIVE;  //SD-Card is now free 4 access
                                }
                                
                        SongNrLoad = SongNrStor; //transfair load nr 2 store nr.
                        
                        MUTEX_LCD_TAKE; 
                            MIOS32_LCD_DeviceSet(2); MIOS32_LCD_Clear(); MIOS32_LCD_CursorSet(0, 0); 
                            MIOS32_LCD_PrintFormattedString	("%s", "PROGRAM STORE - Finished");
                        MUTEX_LCD_GIVE;
                        
                        Update_LCD_s = 1; //normal LCD-Labeling in back again in secunds
                                                       
                    break;
    

//  I N I T - S D - CARD //////////////////////////////////////////////////////////////////////////////////7//////   
  
            case 5: //SD-Card Initalize
                    MUTEX_SDCARD_TAKE;					//SD-Card is now only for the following LINES reserved:
                      statusSD = FILE_CheckSDCard();
                      switch(statusSD) {
                          case 2: MUTEX_LCD_TAKE;  MIOS32_LCD_DeviceSet(2); MIOS32_LCD_Clear(); MIOS32_LCD_CursorSet(0, 0); MIOS32_LCD_PrintFormattedString	("%s", "NO SD-Card"); MUTEX_LCD_GIVE;  break; 
                          case 3:
                             if	(!FILE_SDCardAvailable() ) {MUTEX_LCD_TAKE; MIOS32_LCD_DeviceSet(2); MIOS32_LCD_Clear(); MIOS32_LCD_CursorSet(0, 0); MIOS32_LCD_PrintFormattedString	("%s", "Insert-FAT-Formated-SD-Card"); MUTEX_LCD_GIVE; break;} 
                             if	(!FILE_VolumeAvailable() ) {MUTEX_LCD_TAKE; MIOS32_LCD_DeviceSet(2); MIOS32_LCD_Clear(); MIOS32_LCD_CursorSet(0, 0); MIOS32_LCD_PrintFormattedString	("%s", "Format SD-Format to FAT first!"); MUTEX_LCD_GIVE; break;} break;
                          case 1: // YES CARD!  >>> next: check Card-content
                             statusDir = FILE_DirExists("msp");																								//ask file.c: exist a folder "t/" on the CARD?
                             if (statusDir == 1){MUTEX_LCD_TAKE; MIOS32_LCD_DeviceSet(2); MIOS32_LCD_Clear(); MIOS32_LCD_CursorSet(0, 0); MIOS32_LCD_PrintFormattedString	("%s", "good SD-file structure");MenueUpdateFlag = 0;MUTEX_LCD_GIVE; break;} 
                             
                             if (statusDir == 0){MUTEX_LCD_TAKE; MIOS32_LCD_DeviceSet(2); MIOS32_LCD_Clear(); MIOS32_LCD_CursorSet(0, 0); MIOS32_LCD_PrintFormattedString	("%s", "create 4096 Files on SDC it takes 25min - really!-wait!!! ");MUTEX_LCD_GIVE;
                                                           
                                
                                        FILE_MakeDir("msp");                           

                                        //Write to File
                                        sprintf(file_path, "msp/%d-%d.msp", track, clip);             
                                        FILE_WriteOpen	(file_path,                   16 );               
                                                FILE_WriteBuffer( (u8  *)file_type,    4 ); //"msp0" = 4 Positons   
                                                FILE_WriteBuffer( (u8  *)&loop[t], sizeof(store_t) ); 
                                        FILE_WriteClose	(); 
                                                            
                                            //copy-prototype file to 512x8 clip files on SD-Card
                                            for(t=0; t<8; t++){ 
                                                
                                                u16 clipcount = 0; //declare and set the Bank Counter inital value to 0 
                                                for(clipcount = 0; clipcount<512; clipcount++){  //countes 2 511 and do following commandos 511 times in a loop:
                                                    char copyfilepath[16];
                                                    sprintf   (copyfilepath, "msp/%d-%d.msp", t, clipcount); //make a new filename depending on the counter value 1.msp, 2.msp, 3.msp...511.msp
                                                    FILE_Copy ( (char *)"msp/0-0.msp", (char *)copyfilepath );} //copy the File 0.tm to all other 511 files...
                                            }
                                        
                                
                                                                    //SD-Card is now free 4 apbess
                        MUTEX_LCD_TAKE; MIOS32_LCD_DeviceSet(0); MIOS32_LCD_Clear(); MIOS32_LCD_CursorSet(0, 0); MIOS32_LCD_PrintFormattedString	("%s", "SD-CARD - INIT - FINISHED"); MUTEX_LCD_GIVE;MenueUpdateFlag = 0;} break;
                        }
                        MUTEX_SDCARD_GIVE;	
                        }
}


// E D I T   C L I P  D A T A
static void Edit_Clip(u8 track, u16 clip, u16 job){
    // clip is not used in this procedure better to remove it ;)
    switch(job) {
        // Reset(Clear)
        case 0:
            if(edit & (1<<0))wmemset(loop[track].PB, (u32)((8192<<16) + 8192), (sizeof (loop[track].PB))/4); // reset Pitch Bend
            if(edit & (1<<1))memset(loop[track].SEQ, 0, sizeof loop[track].SEQ);                             // reset Note
            if(edit & (1<<2))memset(loop[track].MSQ, 0, sizeof loop[track].MSQ);                             // reset Control Change
            if(edit & (1<<3)){                                                                               // copy track parameters
                loop[track].leader = 0;
                loop[track].virgin = 1;
                loop[track].length = 1;
                loop[track].decay = 60; //maximal 256 since we use u8 integer type
                loop[track].rythm = 4;
                loop[track].bpm = 120;
            }
            break;
        // Copy                
        case 1:
            if(edit & 0x0f)memcpy(&loop_copy, &loop[track], sizeof loop_copy);                               // copy full track
            else{
                if(edit & (1<<0))memcpy(loop_copy.PB, loop[track].PB, sizeof loop_copy.PB);                  // copy Pitch Bend
                if(edit & (1<<1))memcpy(loop_copy.SEQ, loop[track].SEQ, sizeof loop_copy.SEQ);               // copy Note
                if(edit & (1<<2))memcpy(loop_copy.MSQ, loop[track].MSQ, sizeof loop_copy.MSQ);               // copy Control Change
                if(edit & (1<<3)){                                                                           // copy track parameters
                    loop_copy.leader = loop[track].leader;
                    loop_copy.virgin = loop[track].virgin;
                    loop_copy.length = loop[track].length;
                    loop_copy.decay = loop[track].decay;
                    loop_copy.rythm = loop[track].rythm;
                    loop_copy.bpm = loop[track].bpm;
                }
            }
            break;
        // Paste                
        case 2:
            if(edit & 0x0f)memcpy(&loop[track], &loop_copy, sizeof loop_copy);                               // paste full track
            else{
                if(edit & (1<<0))memcpy(loop[track].PB, loop_copy.PB, sizeof loop[track].PB);                // paste Pitch Bend
                if(edit & (1<<1))memcpy(loop[track].SEQ, loop_copy.SEQ, sizeof loop[track].SEQ);             // paste Note
                if(edit & (1<<2))memcpy(loop[track].MSQ, loop_copy.MSQ, sizeof loop[track].MSQ);             // paste Control Change
                if(edit & (1<<3)){                                                                           // paste track parameters
                    loop[track].leader = loop_copy.leader;
                    loop[track].virgin = loop_copy.virgin;
                    loop[track].length = loop_copy.length;
                    loop[track].decay = loop_copy.decay;
                    loop[track].rythm = loop_copy.rythm;
                    loop[track].bpm = loop_copy.bpm;
                }
            }
            break;
    }
}
    

static void Note_Buffer(u8 velocity, u8 note){  //Melody Input buffer    -    wich we write into the current step of the sequence (used in Function: REC_PLAY)
    
    if (note > 0  &&  note < 127  &&  velocity >= 1){    // Only Note Numbers in Midi-Range 0-127 && Only Note On Messages       
                                
       //CLEAR NOTE BUFFER
         if (NoteCount==0)   { u8 c; for(c=0; c<8; ++c) RecNoteBuff[c] = 0;}//set to Note Nr 0, which we filter later out
         
       //FILL  NOTE BUFFER
         if (NoteCount == 0) {RecNoteBuff[0]  = note;}
         if (NoteCount == 1) {RecNoteBuff[1]  = note;}          
         if (NoteCount == 2) {RecNoteBuff[2]  = note;}
         if (NoteCount == 3) {RecNoteBuff[3]  = note;}
         if (NoteCount == 4) {RecNoteBuff[4]  = note;}
         if (NoteCount == 5) {RecNoteBuff[5]  = note;}
         if (NoteCount == 6) {RecNoteBuff[6]  = note;}
         if (NoteCount == 7) {RecNoteBuff[7]  = note;}                                                                                      
                               
       //NOTE COUNTER 
         NoteCount++; //(cheap Polyphony) counts from 0-7 >> this numbers route the notes in their buffers, when it reaches 8 it begins from 0 again = note overflow
     }
     
    //Count Reset
    if ( (velocity >= 1 && NoteCount >= 8) || (velocity == 0) )   {NoteCount = 0;} //begin again from 0 when reaching max Count of 8 Fingers on Keyboard = max 8 Poly-Chord-Note
}//END of FUNCTION
 
 
static void Counter(void *pvParameters){  //do all with counters, ms, times, flags.....
   portTickType xLastExecutionTime;
   xLastExecutionTime = xTaskGetTickCount();       // Initialise the xLastExecutionTime variable on task entry

  while( 1 ) {
    vTaskDelayUntil(&xLastExecutionTime, 1 / portTICK_RATE_MS);
        

        if (Boot_Flag == 1)  {MenueUpdateFlag = 0; Boot_Flag = 0;} //if booted then update the LCDs


        //Blinking LEDs...
       if   (Blink_Button_count[0] <= Blink_Button_time[0]) {
             Blink_Button_count[0]++;
         if (Blink_Button_count[0] >= Blink_Button_time[0])     { Blink_Button[0] =! Blink_Button[0]; Blink_Button_count[0] = 0;} }
    
       if   (Blink_Button_count[1] <= Blink_Button_time[1]) {
             Blink_Button_count[1]++;
         if (Blink_Button_count[1] >= Blink_Button_time[1])     { Blink_Button[1] =! Blink_Button[1]; Blink_Button_count[1] = 0;} }
          
       if   (Blink_Button_count[2] <= Blink_Button_time[2]) {
             Blink_Button_count[2]++;
         if (Blink_Button_count[2] >= Blink_Button_time[2])     { Blink_Button[2] =! Blink_Button[2]; Blink_Button_count[2] = 0;} }  
              
       if   (Blink_Button_count[3] <= Blink_Button_time[3]) {
             Blink_Button_count[3]++;
         if (Blink_Button_count[3] >= Blink_Button_time[3])     { Blink_Button[3] =! Blink_Button[3]; Blink_Button_count[3] = 0;} } 
          
                  
        SDCardCount++; 
        if (SDCardCount > 2000) { SDCardCount = 0; SD(0, 0, 5); } //2s Counter > send Check-SDCard-Commant to StoreLoad-Function (s32 track, s32 clip, s32 job){
        
        
        if (Update_LCD_s == 1) { Upd_LCD_count++;    if (Upd_LCD_count >= 2100) { Upd_LCD_count = 0; Update_LCD_s = 0;   MENUE(126, 0); }  }
            
        if (MenueUpdateFlag==0){MenueUpdateCount++; 
                    if (MenueUpdateCount > 250){MenueUpdateCount = 0; //update the Menue 0,15seconds after a message like "stored" (1.time!)
                                                MenueUpdateFlag=1; //deactivate Timer
                                                MENUE(126, 0);}} //Update LCD with the currently selected Menu}}
        

        //Store all Patterns
        if (StoreFlag == 1) {StoreCount++; 
                         if (StoreCount>250){ StoreCount=0; StoreFlag=0; SD(0, SongNrStor, 4); }} //the direct imideatly Btn Action from a button dont react...so delay here.
   
        //Load all Patterns of Song
        if (LoadFlag == 1) {LoadCount++; 
                        if (LoadCount>250){ LoadCount=0;  LoadFlag=0;  SD(0, SongNrLoad, 2); }} //the direct imideatly Btn Action from a button dont react...so delay here.
             
             
          
        //Programchange Load when Stopped turning the Wheel (from External Source, internal we use a LOAD-Button for that)
        if (PCLoadFlag==1){ PCLoadFlagCount++; 
                        if (PCLoadFlagCount >= 200) {
                                         PCLoadFlagCount = 0; //init counter for the next run
                                         SD(0, SongNrLoad, 2); //LOAD Program
                                         PCLoadFlag = 0;  //Kill Flag to avoid double triggering events
                                         MenueUpdateFlag=0;
                                         MENUE(126, 0);}} //Update LCD with the currently selected Menu}}

}//End While
}//End TICK 0 >>> 1ms Task...


u8 MENUE(u8 menue_cc, u8 menue_incrementer){  //dump out LCD-Data
////////////////////////////////////////////////////////////////
//                                                            //
//  M       E     EEEEEEE    N     N     U     U     EEEEEEE  //                                                                
//  M E   U E     E          N N   N     U     U     E        //                                                          
//  M   N   E     EEEE       N  N  N     U     U     EEEE     //                                                          
//  M       E     E          N   N N     U     U     E        //                                                          
//  M       E     EEEEEEE    N    NN     UUUUUUU     EEEEEEE  //                                                          
//                                                            //
switch (menue_cc) {

    // D U M P   O U T   T O   L C Ds
    case 126:
    /////////////////////////////////
    
        if (ActualMenue == 0) {  // Upper Page Bank

            if (Menue[0] == 0) { // MENU PAGE: 0 - loop.length
                    
                    //calculate Loop-Length
                    s16 l = 0;
                    for(l=0; l<8; ++l) Loop[l] = loop[l].length * MainLoop;
                        
                    MUTEX_LCD_TAKE;
                            MIOS32_LCD_DeviceSet  (0);  //LCD 0    
                            MIOS32_LCD_Clear();
                            MIOS32_LCD_CursorSet(0,  0); MIOS32_LCD_PrintFormattedString("%d x %d", loop[0].length, MainLoop);
                            MIOS32_LCD_CursorSet(17, 0); MIOS32_LCD_PrintFormattedString("%d x %d", loop[1].length, MainLoop);
                            MIOS32_LCD_CursorSet(34, 0); MIOS32_LCD_PrintFormattedString("%d x %d", loop[2].length, MainLoop);
            
                            MIOS32_LCD_CursorSet(0,  1); MIOS32_LCD_PrintFormattedString("=%d", Loop[0]);
                            MIOS32_LCD_CursorSet(17, 1); MIOS32_LCD_PrintFormattedString("=%d", Loop[1]);
                            MIOS32_LCD_CursorSet(34, 1); MIOS32_LCD_PrintFormattedString("=%d", Loop[2]);         
                    MUTEX_LCD_GIVE;
                            
                    MUTEX_LCD_TAKE;              
                            MIOS32_LCD_DeviceSet  (1);  //LCD 1          
                            MIOS32_LCD_Clear();
                            MIOS32_LCD_CursorSet(0,  0); MIOS32_LCD_PrintFormattedString("%d x %d", loop[3].length, MainLoop);
                            MIOS32_LCD_CursorSet(17, 0); MIOS32_LCD_PrintFormattedString("%d x %d", loop[4].length, MainLoop);
                            MIOS32_LCD_CursorSet(34, 0); MIOS32_LCD_PrintFormattedString("%d x %d", loop[5].length, MainLoop);
            
                            MIOS32_LCD_CursorSet(0,  1); MIOS32_LCD_PrintFormattedString("=%d", Loop[3]);
                            MIOS32_LCD_CursorSet(17, 1); MIOS32_LCD_PrintFormattedString("=%d", Loop[4]);
                            MIOS32_LCD_CursorSet(34, 1); MIOS32_LCD_PrintFormattedString("=%d", Loop[5]);    
                    MUTEX_LCD_GIVE;
                            
                    MUTEX_LCD_TAKE;                                  
                            MIOS32_LCD_DeviceSet  (2);  //LCD 2  
                            MIOS32_LCD_Clear();     
                            MIOS32_LCD_CursorSet(0,  0); MIOS32_LCD_PrintFormattedString("%d x %d", loop[6].length, MainLoop);
                            MIOS32_LCD_CursorSet(17, 0); MIOS32_LCD_PrintFormattedString("%d x %d", loop[7].length, MainLoop);
            
                            MIOS32_LCD_CursorSet(0,  1); MIOS32_LCD_PrintFormattedString("=%d", Loop[6]);
                            MIOS32_LCD_CursorSet(17, 1); MIOS32_LCD_PrintFormattedString("=%d", Loop[7]);
                
                            //Button-Bank-Describtion
                            MIOS32_LCD_CursorSet(29,0); MIOS32_LCD_PrintFormattedString("LOOP-Length");                                
                            MIOS32_LCD_CursorSet(36,1); MIOS32_LCD_PrintFormattedString("REC");
                    MUTEX_LCD_GIVE;					// release LCD access for other tasks  	
            }         
            
            if (Menue[0] == 1) { // MENU PAGE: 1 - transport & Beat-Structure 4/4 5/4... Recording-Settings - Program-Change 0-127
                             
                    MUTEX_LCD_TAKE; //request LCD Access 
                            MIOS32_LCD_DeviceSet  (0);  //LCD 0       
                            MIOS32_LCD_Clear();  
                            MIOS32_LCD_CursorSet(0, 0);     MIOS32_LCD_PrintFormattedString("Start");
                            MIOS32_LCD_CursorSet(0, 1);     MIOS32_LCD_PrintFormattedString("Stop");
                            MIOS32_LCD_CursorSet(18, 0);    MIOS32_LCD_PrintFormattedString("BPM");
                            MIOS32_LCD_CursorSet(18, 1);    MIOS32_LCD_PrintFormattedString("%d",   loop[ActualSEQ].bpm);
                            MIOS32_LCD_CursorSet(36, 0);    MIOS32_LCD_PrintFormattedString("%d/4", loop[ActualSEQ].rythm);
                    MUTEX_LCD_GIVE;
                    
                    MUTEX_LCD_TAKE;
                            MIOS32_LCD_DeviceSet  (1);  //LCD 1     
                            MIOS32_LCD_Clear();  
                            MIOS32_LCD_CursorSet(0, 0);    MIOS32_LCD_PrintFormattedString("RecOffset");
                            MIOS32_LCD_CursorSet(0, 1);    MIOS32_LCD_PrintFormattedString("%d", 0 - RecOffset);
                            MIOS32_LCD_CursorSet(16, 0);    MIOS32_LCD_PrintFormattedString("Store Nr");
                            MIOS32_LCD_CursorSet(18, 1);    MIOS32_LCD_PrintFormattedString("%d", SongNrStor+1);
                            MIOS32_LCD_CursorSet(33, 0);    MIOS32_LCD_PrintFormattedString("Load Nr");                            
                            MIOS32_LCD_CursorSet(36, 1);    MIOS32_LCD_PrintFormattedString("%d", SongNrLoad+1);
                    MUTEX_LCD_GIVE;

                    MUTEX_LCD_TAKE;
                            MIOS32_LCD_DeviceSet  (2);  //LCD 2     
                            MIOS32_LCD_Clear();  
                            MIOS32_LCD_CursorSet(0, 0);    MIOS32_LCD_PrintFormattedString("Store");
                            MIOS32_LCD_CursorSet(0, 1);    MIOS32_LCD_PrintFormattedString("Load");
                    MUTEX_LCD_GIVE;
                }

                
           
            if (Menue[0] == 2) { // MENU PAGE: 0      -       MUTE & REC   NOTES and PITCHBEND

                    MUTEX_LCD_TAKE;
                            MIOS32_LCD_DeviceSet  (0);  //LCD 0       
                            MIOS32_LCD_Clear();  
                            MIOS32_LCD_CursorSet(0, 0);     MIOS32_LCD_PrintFormattedString("             Select Track              ");
                            MIOS32_LCD_CursorSet(0, 1);     MIOS32_LCD_PrintFormattedString(" @PB             @SEQ              @MSQ");
                    MUTEX_LCD_GIVE;
                    
                    MUTEX_LCD_TAKE;
                            MIOS32_LCD_DeviceSet  (1);  //LCD 1       
                            MIOS32_LCD_Clear();  
                            MIOS32_LCD_CursorSet(0, 0);     MIOS32_LCD_PrintFormattedString("             Select Track              ");
                            MIOS32_LCD_CursorSet(0, 1);     MIOS32_LCD_PrintFormattedString("@beat-info      clear!            copy!");
                    MUTEX_LCD_GIVE;
                    
                    MUTEX_LCD_TAKE;
                            MIOS32_LCD_DeviceSet  (2);  //LCD 2          
                            MIOS32_LCD_Clear();  
                            // Button-Bank-Describtion
                            MIOS32_LCD_CursorSet(0, 0);     MIOS32_LCD_PrintFormattedString("             Select Track              ");
                            MIOS32_LCD_CursorSet(0, 1);     MIOS32_LCD_PrintFormattedString("paste!       sync-loop!      copy-paste");
                    MUTEX_LCD_GIVE;					// release LCD access for other tasks  	  
                }
                              

            if (Menue[0] == 3) { //empty
                    MUTEX_LCD_TAKE; //request LCD Access 
                            MIOS32_LCD_DeviceSet  (0);  //LCD 0       
                            MIOS32_LCD_Clear();  
                            MIOS32_LCD_DeviceSet  (1);  //LCD 1     
                            MIOS32_LCD_Clear();                             
                            MIOS32_LCD_DeviceSet  (2);  //LCD 2     
                            MIOS32_LCD_Clear();  
                    MUTEX_LCD_GIVE;
                }                    
            }
        
        
        else {  //Lower Page Bank
            
            //MENU PAGE: 0      -       MUTE & REC   NOTES and PITCHBEND
            if (Menue[1] == 0) {

                    MUTEX_LCD_TAKE;
                            MIOS32_LCD_DeviceSet  (0);  //LCD 0       
                            MIOS32_LCD_Clear();  
                            //Button-Bank-Describtion
                            MIOS32_LCD_CursorSet(0, 0);     MIOS32_LCD_PrintFormattedString("  1a              1b                2a");
                    MUTEX_LCD_GIVE;
                    
                    MUTEX_LCD_TAKE;
                            MIOS32_LCD_DeviceSet  (1);  //LCD 1       
                            MIOS32_LCD_Clear();  
                            //Button-Bank-Describtion
                            MIOS32_LCD_CursorSet(0, 0);     MIOS32_LCD_PrintFormattedString("  2b              3a                3b");
                    MUTEX_LCD_GIVE;
                    
                    MUTEX_LCD_TAKE;
                            MIOS32_LCD_DeviceSet  (2);  //LCD 2          
                            MIOS32_LCD_Clear();  
                            //Button-Bank-Describtion
                            MIOS32_LCD_CursorSet(0, 0);     MIOS32_LCD_PrintFormattedString("  4a              4b               MUTE");
                            MIOS32_LCD_CursorSet(0, 1);     MIOS32_LCD_PrintFormattedString(" REC PB+Note @ same time            REC");
                    MUTEX_LCD_GIVE;					// release LCD access for other tasks  	  
                }


            //MENU PAGE: 1      -       REC   PITCHBEND only
             if (Menue[1] == 1) {
                 
                    MUTEX_LCD_TAKE;
                            MIOS32_LCD_DeviceSet  (0);  //LCD 0       
                            MIOS32_LCD_Clear();  
                            //Button-Bank-Describtion
                            MIOS32_LCD_CursorSet(0, 0);     MIOS32_LCD_PrintFormattedString("Upper Buttons: do you want Record PB &");
                            MIOS32_LCD_CursorSet(0, 1);     MIOS32_LCD_PrintFormattedString("  1a              1b                2a");
                    MUTEX_LCD_GIVE;
                                     
                    MUTEX_LCD_TAKE;
                            MIOS32_LCD_DeviceSet  (1);  //LCD 1       
                            MIOS32_LCD_Clear();  
                            //Button-Bank-Describtion
                            MIOS32_LCD_CursorSet(0, 0);     MIOS32_LCD_PrintFormattedString("and Notes @ once with the  REC-Button?");
                            MIOS32_LCD_CursorSet(0, 1);     MIOS32_LCD_PrintFormattedString("  2b              3a                3b");
                    MUTEX_LCD_GIVE;
                    
                    MUTEX_LCD_TAKE;
                            MIOS32_LCD_DeviceSet  (2);  //LCD 2          
                            MIOS32_LCD_Clear();  
                            //Button-Bank-Describtion
                            MIOS32_LCD_CursorSet(0, 0);     MIOS32_LCD_PrintFormattedString("which itself is a Menue downer ");
                            MIOS32_LCD_CursorSet(0, 1);     MIOS32_LCD_PrintFormattedString("  4a              4b        REC-PB-only");
                    MUTEX_LCD_GIVE;					// release LCD access for other tasks  	  
                }               
                

            //MENU PAGE: 0      -       MUTE & REC   NOTES and PITCHBEND
            if (Menue[1] == 2) {

                    MUTEX_LCD_TAKE;
                            MIOS32_LCD_DeviceSet  (0);  //LCD 0       
                            MIOS32_LCD_Clear();  
                            //Button-Bank-Describtion
                            MIOS32_LCD_CursorSet(0, 0);     MIOS32_LCD_PrintFormattedString("  1a              1b                2a");
                    MUTEX_LCD_GIVE;
                    
                    MUTEX_LCD_TAKE;
                            MIOS32_LCD_DeviceSet  (1);  //LCD 1       
                            MIOS32_LCD_Clear();  
                            //Button-Bank-Describtion
                            MIOS32_LCD_CursorSet(0, 0);     MIOS32_LCD_PrintFormattedString("  2b              3a                3b");
                    MUTEX_LCD_GIVE;
                    
                    MUTEX_LCD_TAKE;
                            MIOS32_LCD_DeviceSet  (2);  //LCD 2          
                            MIOS32_LCD_Clear();  
                            //Button-Bank-Describtion
                            MIOS32_LCD_CursorSet(0, 0);     MIOS32_LCD_PrintFormattedString("  4a              4b               MUTE");
                            MIOS32_LCD_CursorSet(0, 1);     MIOS32_LCD_PrintFormattedString(" REC PB+Note @ same time            REC");
                    MUTEX_LCD_GIVE;					// release LCD access for other tasks  	  
                }
                              
            }             

            if (Menue[1] == 3) { //empty
                    MUTEX_LCD_TAKE; //request LCD Access 
                            MIOS32_LCD_DeviceSet  (0);  //LCD 0       
                            MIOS32_LCD_Clear();  
                            MIOS32_LCD_DeviceSet  (1);  //LCD 1     
                            MIOS32_LCD_Clear();                             
                            MIOS32_LCD_DeviceSet  (2);  //LCD 2     
                            MIOS32_LCD_Clear();  
                    MUTEX_LCD_GIVE;
                }                    
    break;

    } 
  return 0; // no error,

}//END TASK///////////////////////////////////////////////////////////////////////////////////////////////////


/////////////////////
//Note Off Generation
static void Decay(void *pvParameters){  //Send Note OFFs after a while
   portTickType xLastExecutionTime;
   xLastExecutionTime = xTaskGetTickCount();       // Initialise the xLastExecutionTime variable on task entry
  while( 1 ) {
    vTaskDelayUntil(&xLastExecutionTime, 1 / portTICK_RATE_MS);
    
    for(DcyNteCount = 1;  DcyNteCount < 128; DcyNteCount++) {
                        for(DcyTrkCount = 0; DcyTrkCount < 8;   DcyTrkCount++) {
                            
                                   if   (MeloDecayTIMER[DcyTrkCount][DcyNteCount] != 0) {
                                         MeloDecayTIMER[DcyTrkCount][DcyNteCount]   --;
                                         
                                      if (MeloDecayTIMER[DcyTrkCount][DcyNteCount] == 0) {
                                           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[DcyTrkCount], DcyNteCount, 0); //Port, Chn, Note, Velocity 
                                           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[DcyTrkCount], DcyNteCount, 0);}}  
                                    }}
}//End While
}//End TICK 0 >>> 1ms Task...
